capture log close
clear all
macro drop _all
cd "C:\Users\alice\Quantonomics Dropbox\Quantonomics Team Folder\AER25\2. Benchmarking\2. DNSP Benchmarking\DNSP 2025 benchmarking - Supporting Files - 23Jun2025\Stata files\Opex Cost Model\Data management"
set more off
log using Outputs/log/m_DNSPopex25, replace text
*set scheme vg_s1c

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function
Author:  Michael Cunningham
File:    m_DNSPopex25.do
Initial Date:    3-Jul-2022
Revised Date:	23-Jun-2025
--------------------------------------------------------------------------*/

tempfile nz ontario

* A. New Zealand DNSPs
*--------------------------------------------------------------------------

import excel "Inputs/Quantonomics-AER-NZData-18Jun2025", clear ///
	sheet("NZ  ABR25") cellrange(A1:M362) firstrow case(l)
sort eiid year	
describe, fullnames

rename opex000 opex
rename rmdmw rmdem
rename customernumbers custnum
rename circuitlengthkm circlen
rename shareofundergroundcables shareugc
rename priceopexindex propex

drop maximumcoincidentsystemdemand undergroundlengthkm maximumdemandmw
order eiid dnspname year country opex propex rmdem custnum circlen shareugc
*tabmiss
describe

save `nz'
export excel "Outputs/xlsx/OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("nz", replace)

* B. Ontario
*--------------------------------------------------------------------------

import excel "Inputs/Ontario ABR25 Data -23Jun2025", clear ///
	sheet("Ontario ABR25") cellrange(A1:M552) firstrow case(l)
sort eiid year	
describe, fullnames

rename rmdemand rmdem
drop uglen maxdem energydelivered


*tabmiss
describe

save `ontario'
export excel "Outputs/xlsx/OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("ont", replace)

* C. Australia 
*--------------------------------------------------------------------------

use Inputs/dnspbench25-firm, clear

gen int eiid = 1000 + dnsp
gen byte country = 1

rename price_opex propex
rename customers custnum
rename ucshare shareugc
rename ratchetmd rmdem
rename circlength circlen

decode dnsp, generate(name0)
split name0, parse(.) generate(name)
drop name0 name1
rename name2 name0
split name0, parse(": ") generate(name)
rename name2 dnspname

sort eiid year
keep country eiid year opex propex rmdem custnum circlen shareugc ///
	dnspname
order eiid dnspname year country opex propex rmdem custnum circlen shareugc
export excel "Outputs/xlsx/OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("aus", replace)
	
* D. Append
*-----------------------------------------------------
	
append using `nz' `ontario'
sort eiid year

replace shareugc = 0.01 if shareugc < 0.01
label define country 1 "1.Aust" 2 "2.NZ" 3 "3.Ontario"
label values country country
labmask eiid, values(dnspname)	
drop dnspname

label variable opex  			"Operating expenditure (local currency, 000)"
label variable custnum			"Customers (#)"
label variable circlen			"Circuit length (km)"
label variable shareugc			"Underground cable: % of circuit length"
label variable rmdem 			"Ratcheted maximum demand (MW)"
label variable propex			"Opex price index (2005 = 1.0)"
label variable country			"Country code"
label variable eiid				"Utility code"
label variable year				"Reporting year"

tab1 country eiid
describe
summarize 
*tabmiss

save Outputs/dta/DNSPopex25, replace


log close
exit

